

/***********************************************************************************************
 *                                                                                             *
 *                        Example_1. ET-REMOTE MP3 COMMAND-Mode By Sent Command                *
 *                                                                                             *
 ***********************************************************************************************
 *                                                                                             *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR atmega128 r3)                               *
 *                : X-TAL : 16 MHz                                                             * 
 *                                                                                             *
 * Editor         : AVR Studio 4.15 Build 623                                                  *
 * Compiler       : WinAVR-20081205                                                            *
 *                                                                                             *
 * Port Interface :                                                                            *
 *                                                                                             *
 *                : # MCU-MEGA128 #               # ET-REMOTE MP3 V2 #                         *
 *                  --------------                --------------------                         *
 *          UART0 :    PE0(RX0)        Connect        Tx                                       *
 *                     PE1(TX0)        Connect        Rx                                       *
 *                     GND             Connect        GND                                      *
 *                     BAUD RATE 9600                                                          *  
 *              5V                                                                             *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIP SW.MODE         *
 *              |                  |                                       S1=ON ; S2=ON       *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON ; S2=OFF      *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX0   |       |   |   |   |----+              |                       *
 *       |          PE0+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX0   |       |   | |     |   ||              |      /  |             *
 *       |          PE1+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       | AVR Mega 128|           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have number File 15 File           *
 *                   Play File Numbe 1 once and Play Repeat File Number 2-15                   *
 *                                                                                             *
 * Last Update     : 28/May/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/





#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit




#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay

unsigned char num_hi,num_lo  ;       //Keep Ascii byte high and low


/*****************************************
 **         Function Delay ms           **
 *****************************************/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }



/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL,_FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);


//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
     fputs("*ring*\n",stderr) ;
     return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }


//------------------- Initial UART0 -----------------------

static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 103       ;     //Set Baud Rate 9600
  
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter and INT.Rx

   stdout = &uart_str ;     //Set address uart_str to stdout

   

 }




//---------- Check Respond Command & End of Fili From Board MP3 -----------------
 

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm()
 {
   unsigned char buf_cmm[2] ;
   unsigned char n,ch ;
   
   do
    {
      do
       {
         loop_until_bit_is_set(UCSR0A,RXC)       ; //Check data in Rx_buffer
         ch = UDR0                               ; //Read data Start Byte
       }while(ch != '#')                         ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                             //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         loop_until_bit_is_set(UCSR0A,RXC)       ; //Check data in Rx_buffer
         buf_cmm[n] = UDR0                       ; //Read Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }



//-------------- Check Echo End Of File(&E) ---------------

void Echo_EOF()
 {
   
   unsigned char eof,ch ;
   
   do
    {
      do
       {
         loop_until_bit_is_set(UCSR0A,RXC)     ; //Check data in Rx_buffer
         ch = UDR0                             ; //Read Data
       }while(ch != '&')                       ; //Check Byte Start of Echo EOF('&')

        loop_until_bit_is_set(UCSR0A,RXC)      ; //Check data in Rx_buffer
        eof = UDR0                             ; //Read Data 
            
    }while(eof!='E')                           ;  //Check Echo EOF = 'E' Exit loop
 }


//--------------- Convert Dec(01-99) To Ascii 2 Colume  --------------------

void Dec_to_Ascii(unsigned char num_fi)
 {
   if(num_fi <= 99)
    {
      num_hi = (num_fi/10)+0x30   ; //Convert to Ascii Byte High
      num_lo = (num_fi%10)+0x30   ; //Convert to Ascii Byte Low 
    }
 }



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
  {
    unsigned char num,enter  = 0x0D  ;

    UART0_Init()      ;
    delay_ms(2000)    ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------

    printf("*CF=000%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,0:Not Display Time
    Echo_Cmm()                     ;   //Check CMM'#OK'
  
    printf("*VL=60%c",enter)       ;   //Sent CMM Set Volum='60'
    Echo_Cmm()                     ;   //Check CMM'#OK'

    printf("*P1=01%c",enter)       ;   //Sent CMM Play File by Number :Start File #1
    Echo_Cmm()                     ;   //Check CMM'#OK'
    Echo_EOF()                     ;   //Check End of File
    

   //------------- Loop Play file Number #2-#15 Repeat All  -----------
    
   num = 2 ;
   while(1)
     {

      Dec_to_Ascii(num)                         ;   //Convert Number File to Ascii
      printf("*P1=%c%c%c",num_hi,num_lo,enter)  ;   //Sent CMM Play File by Number :Start File #2
      Echo_Cmm()                                ;   //Check CMM'#OK'
      Echo_EOF()                                ;   //Check End of File
      num++                                     ;   //Increment Next Number File
 
      if(num==16)                                   //Check File Last number 15
       num = 2                                  ;   //New Start File Number 2 
     }    
 
  }































